/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.remote;

import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.remote.common.MaterialEvent;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.store.TransactionStoreActivity;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.problems.Problem;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialEventsLoader {
    private static final Logger log = LoggerFactory.getLogger(MaterialEventsLoader.class);
    private final Superplan superplan;
    private final Plan plan;
    private final ShopConfiguration conf;
    private final List<Problem> problems;

    private MaterialEventsLoader(Superplan superplan) {
        this.superplan = superplan;
        this.plan = superplan.getPlan();
        this.conf = superplan.getShopConf();
        this.problems = Lists.newArrayList();
    }

    private void clearStoreActivities() {
        this.plan.getStoreSchedule(StoreType.EXTERNAL).removeAllActivities();
        this.plan.getStoreSchedule(StoreType.TRANSACTION).removeAllActivities();
    }

    private void loadEvents(List<MaterialEvent> materialEvents) {
        this.problems.clear();
        for (MaterialEvent me : materialEvents) {
            Material material = this.conf.getMatprod(me.getMaterial());
            Date date = me.getDate();
            if (date == null) {
                log.warn("Skipping material event {} that doesn't have date set.", (Object)me);
                this.problems.add(Problem.createProblem2("01300", me));
                continue;
            }
            if (material == null) {
                log.warn("Skipping material event {} because it has unknown material.", (Object)me);
                this.problems.add(Problem.createProblem2("01500", me));
                continue;
            }
            long time = date.getTime();
            StoreActivity sa = switch (me.getLinkingType()) {
                case MaterialEvent.LinkingType.GOR -> {
                    GeneralizedOrderRequest gor = this.superplan.getGor(me.getLinkTarget());
                    if (gor == null) {
                        log.warn("Target GOR not found for material event {}. Creating external activity instead.", (Object)me);
                        this.problems.add(Problem.createProblem2("03750", me));
                        yield new ExternalStoreActivity(time, material, me.getQty(), me.getDescription());
                    }
                    yield new TransactionStoreActivity(time, material, me.getQty(), gor);
                }
                case MaterialEvent.LinkingType.UNLINKED -> new ExternalStoreActivity(time, material, me.getQty(), me.getDescription());
                default -> throw new IllegalStateException("Unknown material event linking type received.");
            };
            if (sa == null) continue;
            this.plan.addActivity(sa);
        }
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    public static MaterialEventsLoader reloadMaterialEvents(Superplan superplan, List<MaterialEvent> materialEvents) {
        MaterialEventsLoader loader = new MaterialEventsLoader(superplan);
        loader.clearStoreActivities();
        loader.loadEvents(materialEvents);
        return loader;
    }
}

